
COMMENT: This syntax replicates the results of the SAS code for Chapter 9, Table 2;  The BIC Statistic is calculated differently and the intercept sometimes
differs because of the signs of some effects; syntax copyright Robert B Smith,  2011.

COMMENT: The SAS code defines these variables as follows: sofices35 = sixoffices, the nesting  variable; TESPonly = officetypeCFRD; 
V2kOnly = OfficetypeM2k; OneSys = OfficetypeOneSys; BothSys = OfficetypeBothSys; ZeroSys = OfficetypeNoNewSys; nwanti3 = antiIndex.

COMMENT: Syntax for Model 1, Table 9.2.
MIXED
  nwanti3  
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC) .


COMMENT: Syntax for Model 2, Table 9.2.
MIXED
  nwanti3  WITH fac1_1 fac2_1
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = fac1_1 fac2_1  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC) .


COMMENT: Syntax for Model 3a, Table 9.2.
MIXED
  nwanti3  BY tesponly  WITH fac1_1 fac2_1
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = tesponly fac1_1 fac2_1 | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC) .


COMMENT: Syntax for Model 3b, Table 9.2.
MIXED
  nwanti3  BY tesponly  WITH fac1_1 fac2_1
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = tesponly fac1_1 fac2_1 | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC) 
  /EMMEANS = TABLES(tesponly).


COMMENT: Syntax for Model 3c, Table 9.2.
MIXED
  nwanti3  BY OneSys  WITH fac1_1 fac2_1
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = fac1_1 fac2_1 OneSys | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC)
  /EMMEANS = TABLES(OneSys) .


COMMENT: Syntax for Model 3d, Table 9.2.
MIXED
  nwanti3  BY BothSys  WITH fac1_1 fac2_1
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = fac1_1 fac2_1 BothSys | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC)
  /EMMEANS = TABLES(BothSys) .

COMMENT: Syntax for Model 4, Table 9.2.
MIXED
  nwanti3  BY bothsys onesys  WITH fac1_1 fac2_1
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = fac1_1 fac2_1 bothsys onesys  | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC)
  /EMMEANS = TABLES(bothsys)
  /EMMEANS = TABLES(onesys)  .


COMMENT: Syntax for Model 5, Table 9.2.
MIXED
  nwanti3  BY bothsys TESPOnly V2KOnly  WITH fac1_1 fac2_1
  /CRITERIA = CIN(95) MXITER(100) MXSTEP(5) SCORING(1) SINGULAR(0.000000000001) HCONVERGE(0, ABSOLUTE) LCONVERGE(0, ABSOLUTE)
  PCONVERGE(0.000001, ABSOLUTE)
  /FIXED = fac1_1 fac2_1 bothsys TESPOnly V2KOnly   | SSTYPE(3)
  /METHOD = REML
  /PRINT = SOLUTION TESTCOV
 /RANDOM INTERCEPT  | SUBJECT(sofice35) COVTYPE(VC)
  /EMMEANS = TABLES(bothsys)
  /EMMEANS = TABLES(TESPOnly) 
  /EMMEANS = TABLES(V2KOnly). 